#!/bin/bash
# modified from Hora
GPUS=$1
SCALE=$2
HEADLESS=$3
NUMENVS=$4



reset_height_threshold=0.355

array=( $@ )
len=${#array[@]}
EXTRA_ARGS=${array[@]:4:$len}
EXTRA_ARGS_SLUG=${EXTRA_ARGS// /_}

echo extra "${EXTRA_ARGS}"


CUDA_VISIBLE_DEVICES=${GPUS} \
python gen_grasp.py task=LeapHandGrasp train=AllegroHandHora headless=${HEADLESS} pipeline=cpu \
task.env.numEnvs=${NUMENVS} test=True \
task.env.controller.controlFrequencyInv=8 task.env.episodeLength=50 \
task.env.controller.torque_control=False task.env.genGrasps=True task.env.baseObjScale="${SCALE}" \
task.env.object.type=simple_tennis_ball \
task.env.randomization.randomizeMass=True task.env.randomization.randomizeMassLower=0.05 task.env.randomization.randomizeMassUpper=0.051 \
task.env.randomization.randomizeCOM=False \
task.env.randomization.randomizeFriction=False \
task.env.randomization.randomizePDGains=False \
task.env.randomization.randomizeScale=False \
train.ppo.priv_info=True \
task.env.handFacingDir='down' \
task.env.reset_height_threshold=${reset_height_threshold} \
task.env.grasp_cache_name='leap_down_init0d375' \
${EXTRA_ARGS}
